#!/bin/bash

# QR Code Generator Deployment Script
# Usage: ./deploy.sh username@server-ip

if [ $# -eq 0 ]; then
    echo "Usage: $0 username@server-ip"
    echo "Example: $0 myuser@192.168.1.100"
    exit 1
fi

SERVER=$1
REMOTE_PATH="/var/www/clients/client1/web21/web/qr"

echo "🚀 Deploying QR Code Generator to $SERVER..."

# Build the project first
echo "📦 Building project..."
npx elm make src/Main.elm --output=build/elm.js

# Copy index.html to build directory
cp index.html build/

echo "📤 Uploading files..."

# Use rsync which handles permissions better
rsync -avz --no-perms --no-owner --no-group \
    --exclude="elm-stuff" \
    --exclude="node_modules" \
    --exclude=".git" \
    build/ $SERVER:$REMOTE_PATH/

if [ $? -eq 0 ]; then
    echo "✅ Deployment successful!"
    echo "🌐 Your enhanced QR Code Generator should now be live!"
    echo ""
    echo "If you need to fix permissions, SSH to your server and run:"
    echo "chmod -R 755 $REMOTE_PATH"
else
    echo "❌ Deployment failed. Check your connection and permissions."
fi
