port module Main exposing (..)

import Browser
import Html.Styled exposing (toUnstyled)
import Model exposing (Model, QRStyle, CenterContent(..))
import QRCode
import QRTypes exposing (QRType(..))
import State exposing (Msg, update)
import Views.AppView exposing (appView)


-- PORTS
port downloadQRCodePNG : String -> Cmd msg


main : Program () Model Msg
main =
    Browser.document { init = \() -> init, update = update, view = view, subscriptions = \_ -> Sub.none }


init : ( Model, Cmd Msg )
init =
    ( { qrType = QRText ""
      , errorCorrection = QRCode.Quartile
      , qrStyle = defaultQRStyle
      , hoveredFont = Nothing
      , fontDropdownOpen = False
      }
    , Cmd.none
    )


defaultQRStyle : QRStyle
defaultQRStyle =
    { foregroundColor = "#000000"
    , backgroundColor = "#FFFFFF"
    , cornerRadius = 0.0
    , moduleScale = 1.0
    , centerContent = NoCenterContent
    , size = 200
    }


view : Model -> Browser.Document Msg
view model =
    { title = "QR Code Generator"
    , body = [ toUnstyled <| appView model ]
    }
